// Copyright (C) 2025 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial

#ifndef QMULTIMEDIA_RANGES_P_H
#define QMULTIMEDIA_RANGES_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API. It exists purely as an
// implementation detail. This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <QtCore/qtconfigmacros.h>

#ifdef __cpp_lib_ranges
#  include <ranges> // IWYU pragma: export
#endif

#include <algorithm>

QT_BEGIN_NAMESPACE

namespace QtMultimediaPrivate::ranges {

#ifdef __cpp_lib_ranges
using std::ranges::equal;
#else

// Caveat: best effort, not a 1-to-1 mapping to c++20 style ranges

constexpr auto equal = [](const auto &lhs, const auto &rhs, auto &&predicate) {
    return std::equal(lhs.begin(), lhs.end(), rhs.begin(), rhs.end(), predicate);
};

#endif

} // namespace QtMultimediaPrivate::ranges

QT_END_NAMESPACE

#endif // QMULTIMEDIA_RANGES_P_H

